"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    channel_arn: str,
    single_master_channel_endpoint_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the SingleMasterChannelEndpointConfiguration input parameter, which consists of the Protocols and Role properties.  Protocols is used to determine the communication mechanism. For example, if you specify WSS as the protocol, this API produces a secure websocket endpoint. If you specify HTTPS as the protocol, this API generates an HTTPS endpoint.   Role determines the messaging permissions. A MASTER role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A VIEWER role results in this API generating an endpoint that a client can use to communicate only with a MASTER.

    Args:
        channel_arn(str): The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.
        single_master_channel_endpoint_configuration(Dict, optional): A structure containing the endpoint configuration for the SINGLE_MASTER channel type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.signaling_channel.endpoint.get(
                ctx, channel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.signaling_channel.endpoint.get channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="get_signaling_channel_endpoint",
        op_kwargs={
            "ChannelARN": channel_arn,
            "SingleMasterChannelEndpointConfiguration": single_master_channel_endpoint_configuration,
        },
    )
