"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to a signaling channel. A tag is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.
        tags(List): A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="tag_resource",
        op_kwargs={"ResourceARN": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_key_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.
        tag_key_list(List): A list of the keys of the tags that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.resource.untag(
                ctx, resource_arn=value, tag_key_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.resource.untag resource_arn=value, tag_key_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="untag_resource",
        op_kwargs={"ResourceARN": resource_arn, "TagKeyList": tag_key_list},
    )
