"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    current_version: str,
    operation: str,
    data_retention_change_in_hours: int,
    stream_name: str = None,
    stream_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the Operation parameter in the request body. In the request, you must specify either the StreamName or the StreamARN.   The retention period that you specify replaces the current value.  This operation requires permission for the KinesisVideo:UpdateDataRetention action. Changing the data retention period affects the data in the stream as follows:   If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.   If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.

    Args:
        stream_name(str, optional): The name of the stream whose retention period you want to change. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream whose retention period you want to change. Defaults to None.
        current_version(str): The version of the stream whose retention period you want to change. To get the version, call either the DescribeStream or the ListStreams API.
        operation(str): Indicates whether you want to increase or decrease the retention period.
        data_retention_change_in_hours(int): The retention period, in hours. The value you specify replaces the current value. The maximum value for this parameter is 87600 (ten years).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.data.retention.update(
                ctx, current_version=value, operation=value, data_retention_change_in_hours=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.data.retention.update current_version=value, operation=value, data_retention_change_in_hours=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="update_data_retention",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "CurrentVersion": current_version,
            "Operation": operation,
            "DataRetentionChangeInHours": data_retention_change_in_hours,
        },
    )
