"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, api_name: str, stream_name: str = None, stream_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the GetMedia or GetMediaForFragmentList operations) or write to it (using the PutMedia operation).   The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.  In the request, specify the stream either by StreamName or StreamARN.

    Args:
        stream_name(str, optional): The name of the stream that you want to get the endpoint for. You must specify either this parameter or a StreamARN in the request. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a StreamName in the request. . Defaults to None.
        api_name(str): The name of the API action for which to get an endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisvideo.data.endpoint.get(ctx, api_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisvideo.data.endpoint.get api_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisvideo",
        operation="get_data_endpoint",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "APIName": api_name,
        },
    )
