"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def discover(
    hub,
    ctx,
    service_execution_role: str,
    resource_arn: str = None,
    input_starting_position_configuration: Dict = None,
    s3_configuration: Dict = None,
    input_processing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.  You can use the inferred schema when configuring a streaming source for your application. When you create an application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show it in the console user interface.

    Args:
        resource_arn(str, optional): The Amazon Resource Name (ARN) of the streaming source. Defaults to None.
        service_execution_role(str): The ARN of the role that is used to access the streaming source.
        input_starting_position_configuration(Dict, optional): The point at which you want Kinesis Data Analytics to start reading records from the specified streaming source discovery purposes. Defaults to None.
        s3_configuration(Dict, optional): Specify this parameter to discover a schema from data in an Amazon S3 object. Defaults to None.
        input_processing_configuration(Dict, optional): The InputProcessingConfiguration to use to preprocess the records before discovering the schema of the records. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.input_schema.discover(
                ctx, service_execution_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.input_schema.discover service_execution_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="discover_input_schema",
        op_kwargs={
            "ResourceARN": resource_arn,
            "ServiceExecutionRole": service_execution_role,
            "InputStartingPositionConfiguration": input_starting_position_configuration,
            "S3Configuration": s3_configuration,
            "InputProcessingConfiguration": input_processing_configuration,
        },
    )
