"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    application_name: str,
    vpc_configuration: Dict,
    current_application_version_id: int = None,
    conditional_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely. Note the following about VPC configurations for Kinesis Data Analytics applications:   VPC configurations are not supported for SQL applications.   When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.

    Args:
        application_name(str): The name of an existing application.
        current_application_version_id(int, optional): The version of the application to which you want to add the VPC configuration. You must provide the CurrentApplicationVersionId or the ConditionalToken. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.
        vpc_configuration(Dict): Description of the VPC to add to the application.
        conditional_token(str, optional): A value you use to implement strong concurrency for application updates. You must provide the ApplicationVersionID or the ConditionalToken. You get the application's current ConditionalToken using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.vpc_configuration.add(
                ctx, application_name=value, vpc_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.vpc_configuration.add application_name=value, vpc_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="add_application_vpc_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "VpcConfiguration": vpc_configuration,
            "ConditionalToken": conditional_token,
        },
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    vpc_configuration_id: str,
    current_application_version_id: int = None,
    conditional_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a VPC configuration from a Kinesis Data Analytics application.

    Args:
        application_name(str): The name of an existing application.
        current_application_version_id(int, optional): The current application version ID. You must provide the CurrentApplicationVersionId or the ConditionalToken. You can retrieve the application version ID using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.
        vpc_configuration_id(str): The ID of the VPC configuration to delete.
        conditional_token(str, optional): A value you use to implement strong concurrency for application updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get the application's current ConditionalToken using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.vpc_configuration.delete(
                ctx, application_name=value, vpc_configuration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.vpc_configuration.delete application_name=value, vpc_configuration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="delete_application_vpc_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "VpcConfigurationId": vpc_configuration_id,
            "ConditionalToken": conditional_token,
        },
    )
