"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_name: str, snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of the application's state data.

    Args:
        application_name(str): The name of an existing application.
        snapshot_name(str): An identifier for the application snapshot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.snapshot.create(
                ctx, application_name=value, snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.snapshot.create application_name=value, snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="create_application_snapshot",
        op_kwargs={"ApplicationName": application_name, "SnapshotName": snapshot_name},
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    snapshot_name: str,
    snapshot_creation_timestamp: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a snapshot of application state.

    Args:
        application_name(str): The name of an existing application.
        snapshot_name(str): The identifier for the snapshot delete.
        snapshot_creation_timestamp(str): The creation timestamp of the application snapshot to delete. You can retrieve this value using or .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.snapshot.delete(
                ctx, application_name=value, snapshot_name=value, snapshot_creation_timestamp=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.snapshot.delete application_name=value, snapshot_name=value, snapshot_creation_timestamp=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="delete_application_snapshot",
        op_kwargs={
            "ApplicationName": application_name,
            "SnapshotName": snapshot_name,
            "SnapshotCreationTimestamp": snapshot_creation_timestamp,
        },
    )


async def describe(hub, ctx, application_name: str, snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a snapshot of application state data.

    Args:
        application_name(str): The name of an existing application.
        snapshot_name(str): The identifier of an application snapshot. You can retrieve this value using .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.snapshot.describe(
                ctx, application_name=value, snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.snapshot.describe application_name=value, snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="describe_application_snapshot",
        op_kwargs={"ApplicationName": application_name, "SnapshotName": snapshot_name},
    )


async def list_all(
    hub, ctx, application_name: str, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about the current application snapshots.

    Args:
        application_name(str): The name of an existing application.
        limit(int, optional): The maximum number of application snapshots to list. Defaults to None.
        next_token(str, optional): Use this parameter if you receive a NextToken response in a previous request that indicates that there is more output available. Set it to the value of the previous call's NextToken response to indicate where the output should continue from. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.snapshot.list_all(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.snapshot.list_all application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="list_application_snapshots",
        op_kwargs={
            "ApplicationName": application_name,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
