"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    application_name: str,
    url_type: str,
    session_expiration_duration_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and returns a URL that you can use to connect to an application's extension. Currently, the only available extension is the Apache Flink dashboard. The IAM role or user used to call this API defines the permissions to access the extension. After the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request that attempts to connect to the extension.  You control the amount of time that the URL will be valid using the SessionExpirationDurationInSeconds parameter. If you do not provide this parameter, the returned URL is valid for twelve hours.  The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.

    Args:
        application_name(str): The name of the application.
        url_type(str): The type of the extension for which to create and return a URL. Currently, the only valid extension URL type is FLINK_DASHBOARD_URL. .
        session_expiration_duration_in_seconds(int, optional): The duration in seconds for which the returned URL will be valid. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.presigned_url.create(
                ctx, application_name=value, url_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.presigned_url.create application_name=value, url_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="create_application_presigned_url",
        op_kwargs={
            "ApplicationName": application_name,
            "UrlType": url_type,
            "SessionExpirationDurationInSeconds": session_expiration_duration_in_seconds,
        },
    )
