"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub, ctx, application_name: str, current_application_version_id: int, output: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an external destination to your SQL-based Kinesis Data Analytics application. If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors.   Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.

    Args:
        application_name(str): The name of the application to which you want to add the output configuration.
        current_application_version_id(int): The version of the application to which you want to add the output configuration. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned. .
        output(Dict): An array of objects, each describing one output configuration. In the output configuration, you specify the name of an in-application stream, a destination (that is, a Kinesis data stream, a Kinesis Data Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.output.add(
                ctx, application_name=value, current_application_version_id=value, output=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.output.add application_name=value, current_application_version_id=value, output=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="add_application_output",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "Output": output,
        },
    )


async def delete(
    hub, ctx, application_name: str, current_application_version_id: int, output_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to the external output destination.

    Args:
        application_name(str): The application name.
        current_application_version_id(int): The application version. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned. .
        output_id(str): The ID of the configuration to delete. Each output configuration that is added to the application (either when the application is created or later) using the AddApplicationOutput operation has a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from the application configuration. You can use the DescribeApplication operation to get the specific OutputId. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.output.delete(
                ctx, application_name=value, current_application_version_id=value, output_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.output.delete application_name=value, current_application_version_id=value, output_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="delete_application_output",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "OutputId": output_id,
        },
    )
