"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, application_name: str, application_maintenance_configuration_update: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the maintenance configuration of the Kinesis Data Analytics application.  You can invoke this operation on an application that is in one of the two following states: READY or RUNNING. If you invoke it when the application is in a state other than these two states, it throws a ResourceInUseException. The service makes use of the updated configuration the next time it schedules maintenance for the application. If you invoke this operation after the service schedules maintenance, the service will apply the configuration update the next time it schedules maintenance for the application. This means that you might not see the maintenance configuration update applied to the maintenance process that follows a successful invocation of this operation, but to the following maintenance process instead. To see the current maintenance configuration of your application, invoke the DescribeApplication operation. For information about application maintenance, see Kinesis Data Analytics for Apache Flink Maintenance.  This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.

    Args:
        application_name(str): The name of the application for which you want to update the maintenance configuration.
        application_maintenance_configuration_update(Dict): Describes the application maintenance configuration update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.maintenance_configuration.update(
                ctx, application_name=value, application_maintenance_configuration_update=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.maintenance_configuration.update application_name=value, application_maintenance_configuration_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="update_application_maintenance_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "ApplicationMaintenanceConfigurationUpdate": application_maintenance_configuration_update,
        },
    )
