"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub, ctx, application_name: str, current_application_version_id: int, input_: Dict
) -> Dict:
    r"""
    **Autogenerated function**

     Adds a streaming source to your SQL-based Kinesis Data Analytics application.  You can add a streaming source when you create an application, or you can use this operation to add a streaming source after you create an application. For more information, see CreateApplication. Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.

    Args:
        application_name(str): The name of your existing application to which you want to add the streaming source.
        current_application_version_id(int): The current version of your application. You must provide the ApplicationVersionID or the ConditionalToken.You can use the DescribeApplication operation to find the current application version.
        input_(Dict): The Input to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.input_.init.add(
                ctx, application_name=value, current_application_version_id=value, input_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.input_.init.add application_name=value, current_application_version_id=value, input_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="add_application_input",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "Input": input_,
        },
    )
