"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_name: str,
    runtime_environment: str,
    service_execution_role: str,
    application_description: str = None,
    application_configuration: Dict = None,
    cloud_watch_logging_options: List = None,
    tags: List = None,
    application_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see Creating an Application.

    Args:
        application_name(str): The name of your application (for example, sample-app).
        application_description(str, optional): A summary description of the application. Defaults to None.
        runtime_environment(str): The runtime environment for the application (SQL-1_0, FLINK-1_6, FLINK-1_8, or FLINK-1_11).
        service_execution_role(str): The IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external resources.
        application_configuration(Dict, optional): Use this parameter to configure the application. Defaults to None.
        cloud_watch_logging_options(List, optional): Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration errors. . Defaults to None.
        tags(List, optional): A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see Using Tagging. Defaults to None.
        application_mode(str, optional): Use the STREAMING mode to create a Kinesis Data Analytics Studio notebook. To create a Kinesis Data Analytics Studio notebook, use the INTERACTIVE mode. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.create(
                ctx, application_name=value, runtime_environment=value, service_execution_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.create application_name=value, runtime_environment=value, service_execution_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="create_application",
        op_kwargs={
            "ApplicationName": application_name,
            "ApplicationDescription": application_description,
            "RuntimeEnvironment": runtime_environment,
            "ServiceExecutionRole": service_execution_role,
            "ApplicationConfiguration": application_configuration,
            "CloudWatchLoggingOptions": cloud_watch_logging_options,
            "Tags": tags,
            "ApplicationMode": application_mode,
        },
    )


async def delete(hub, ctx, application_name: str, create_timestamp: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the application.

    Args:
        application_name(str): The name of the application to delete.
        create_timestamp(str): Use the DescribeApplication operation to get this value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.delete(
                ctx, application_name=value, create_timestamp=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.delete application_name=value, create_timestamp=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="delete_application",
        op_kwargs={
            "ApplicationName": application_name,
            "CreateTimestamp": create_timestamp,
        },
    )


async def describe(
    hub, ctx, application_name: str, include_additional_details: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific Kinesis Data Analytics application. If you want to retrieve a list of all applications in your account, use the ListApplications operation.

    Args:
        application_name(str): The name of the application.
        include_additional_details(bool, optional): Displays verbose information about a Kinesis Data Analytics application, including the application's job plan. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.describe(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.describe application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="describe_application",
        op_kwargs={
            "ApplicationName": application_name,
            "IncludeAdditionalDetails": include_additional_details,
        },
    )


async def list_all(hub, ctx, limit: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Kinesis Data Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status.  If you want detailed information about a specific application, use DescribeApplication.

    Args:
        limit(int, optional): The maximum number of applications to list. Defaults to None.
        next_token(str, optional): If a previous command returned a pagination token, pass it into this value to retrieve the next set of results. For more information about pagination, see Using the AWS Command Line Interface's Pagination Options. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="list_applications",
        op_kwargs={"Limit": limit, "NextToken": next_token},
    )


async def rollback(
    hub, ctx, application_name: str, current_application_version_id: int
) -> Dict:
    r"""
    **Autogenerated function**

    Reverts the application to the previous running version. You can roll back an application if you suspect it is stuck in a transient status.  You can roll back an application only if it is in the UPDATING or AUTOSCALING status. When you rollback an application, it loads state data from the last successful snapshot. If the application has no snapshots, Kinesis Data Analytics rejects the rollback request. This action is not supported for Kinesis Data Analytics for SQL applications.

    Args:
        application_name(str): The name of the application.
        current_application_version_id(int): The current application version ID. You can retrieve the application version ID using DescribeApplication.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.rollback(
                ctx, application_name=value, current_application_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.rollback application_name=value, current_application_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="rollback_application",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
        },
    )


async def start(
    hub, ctx, application_name: str, run_configuration: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call this operation to start your application.

    Args:
        application_name(str): The name of the application.
        run_configuration(Dict, optional): Identifies the run configuration (start parameters) of a Kinesis Data Analytics application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.start(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.start application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="start_application",
        op_kwargs={
            "ApplicationName": application_name,
            "RunConfiguration": run_configuration,
        },
    )


async def stop(hub, ctx, application_name: str, force: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops the application from processing data. You can stop an application only if it is in the running status, unless you set the Force parameter to true. You can use the DescribeApplication operation to find the application status.  Kinesis Data Analytics takes a snapshot when the application is stopped, unless Force is set to true.

    Args:
        application_name(str): The name of the running application to stop.
        force(bool, optional): Set to true to force the application to stop. If you set Force to true, Kinesis Data Analytics stops the application without taking a snapshot.   Force-stopping your application may lead to data loss or duplication. To prevent data loss or duplicate processing of data during application restarts, we recommend you to take frequent snapshots of your application.  You can only force stop a Flink-based Kinesis Data Analytics application. You can't force stop a SQL-based Kinesis Data Analytics application. The application must be in the STARTING, UPDATING, STOPPING, AUTOSCALING, or RUNNING status. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.stop(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.stop application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="stop_application",
        op_kwargs={"ApplicationName": application_name, "Force": force},
    )


async def update(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int = None,
    application_configuration_update: Dict = None,
    service_execution_role_update: str = None,
    run_configuration_update: Dict = None,
    cloud_watch_logging_option_updates: List = None,
    conditional_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code, input configuration, and output configuration.  Kinesis Data Analytics updates the ApplicationVersionId each time you update your application.   You cannot update the RuntimeEnvironment of an existing application. If you need to update an application's RuntimeEnvironment, you must delete the application and create it again.

    Args:
        application_name(str): The name of the application to update.
        current_application_version_id(int, optional): The current application version ID. You must provide the CurrentApplicationVersionId or the ConditionalToken.You can retrieve the application version ID using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.
        application_configuration_update(Dict, optional): Describes application configuration updates. Defaults to None.
        service_execution_role_update(str, optional): Describes updates to the service execution role. Defaults to None.
        run_configuration_update(Dict, optional): Describes updates to the application's starting parameters. Defaults to None.
        cloud_watch_logging_option_updates(List, optional): Describes application Amazon CloudWatch logging option updates. You can only update existing CloudWatch logging options with this action. To add a new CloudWatch logging option, use AddApplicationCloudWatchLoggingOption. Defaults to None.
        conditional_token(str, optional): A value you use to implement strong concurrency for application updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get the application's current ConditionalToken using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.init.update(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.init.update application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="update_application",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "ApplicationConfigurationUpdate": application_configuration_update,
            "ServiceExecutionRoleUpdate": service_execution_role_update,
            "RunConfigurationUpdate": run_configuration_update,
            "CloudWatchLoggingOptionUpdates": cloud_watch_logging_option_updates,
            "ConditionalToken": conditional_token,
        },
    )
