"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    application_name: str,
    cloud_watch_logging_option: Dict,
    current_application_version_id: int = None,
    conditional_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an Amazon CloudWatch log stream to monitor application configuration errors.

    Args:
        application_name(str): The Kinesis Data Analytics application name.
        current_application_version_id(int, optional): The version ID of the Kinesis Data Analytics application. You must provide the CurrentApplicationVersionId or the ConditionalToken.You can retrieve the application version ID using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.
        cloud_watch_logging_option(Dict): Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN). .
        conditional_token(str, optional): A value you use to implement strong concurrency for application updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get the application's current ConditionalToken using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.cloud_watch_logging_option.add(
                ctx, application_name=value, cloud_watch_logging_option=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.cloud_watch_logging_option.add application_name=value, cloud_watch_logging_option=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="add_application_cloud_watch_logging_option",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "CloudWatchLoggingOption": cloud_watch_logging_option,
            "ConditionalToken": conditional_token,
        },
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    cloud_watch_logging_option_id: str,
    current_application_version_id: int = None,
    conditional_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.

    Args:
        application_name(str): The application name.
        current_application_version_id(int, optional): The version ID of the application. You must provide the CurrentApplicationVersionId or the ConditionalToken. You can retrieve the application version ID using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.
        cloud_watch_logging_option_id(str): The CloudWatchLoggingOptionId of the Amazon CloudWatch logging option to delete. You can get the CloudWatchLoggingOptionId by using the DescribeApplication operation. .
        conditional_token(str, optional): A value you use to implement strong concurrency for application updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get the application's current ConditionalToken using DescribeApplication. For better concurrency support, use the ConditionalToken parameter instead of CurrentApplicationVersionId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalyticsv2.application.cloud_watch_logging_option.delete(
                ctx, application_name=value, cloud_watch_logging_option_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalyticsv2.application.cloud_watch_logging_option.delete application_name=value, cloud_watch_logging_option_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalyticsv2",
        operation="delete_application_cloud_watch_logging_option",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "CloudWatchLoggingOptionId": cloud_watch_logging_option_id,
            "ConditionalToken": conditional_token,
        },
    )
