"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def discover(
    hub,
    ctx,
    resource_arn: str = None,
    role_arn: str = None,
    input_starting_position_configuration: Dict = None,
    s3_configuration: Dict = None,
    input_processing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.  You can use the inferred schema when configuring a streaming source for your application. For conceptual information, see Configuring Application Input. Note that when you create an application using the Amazon Kinesis Analytics console, the console uses this operation to infer a schema and show it in the console user interface.   This operation requires permissions to perform the kinesisanalytics:DiscoverInputSchema action.

    Args:
        resource_arn(str, optional): Amazon Resource Name (ARN) of the streaming source. Defaults to None.
        role_arn(str, optional): ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. Defaults to None.
        input_starting_position_configuration(Dict, optional): Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes. Defaults to None.
        s3_configuration(Dict, optional): Specify this parameter to discover a schema from data in an Amazon S3 object. Defaults to None.
        input_processing_configuration(Dict, optional): The InputProcessingConfiguration to use to preprocess the records before discovering the schema of the records. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.input_schema.discover(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.input_schema.discover
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="discover_input_schema",
        op_kwargs={
            "ResourceARN": resource_arn,
            "RoleARN": role_arn,
            "InputStartingPositionConfiguration": input_starting_position_configuration,
            "S3Configuration": s3_configuration,
            "InputProcessingConfiguration": input_processing_configuration,
        },
    )
