"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    reference_data_source: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Adds a reference data source to an existing application. Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.  For conceptual information, see Configuring Application Input. For the limits on data sources you can add to your application, see Limits.   This operation requires permissions to perform the kinesisanalytics:AddApplicationOutput action.

    Args:
        application_name(str): Name of an existing application.
        current_application_version_id(int): Version of the application for which you are adding the reference data source. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned.
        reference_data_source(Dict): The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.reference_data_source.add(
                ctx,
                application_name=value,
                current_application_version_id=value,
                reference_data_source=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.reference_data_source.add application_name=value, current_application_version_id=value, reference_data_source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="add_application_reference_data_source",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "ReferenceDataSource": reference_data_source,
        },
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    reference_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Deletes a reference data source configuration from the specified application configuration. If the application is running, Amazon Kinesis Analytics immediately removes the in-application table that you created using the AddApplicationReferenceDataSource operation.  This operation requires permissions to perform the kinesisanalytics.DeleteApplicationReferenceDataSource action.

    Args:
        application_name(str): Name of an existing application.
        current_application_version_id(int): Version of the application. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned.
        reference_id(str): ID of the reference data source. When you add a reference data source to your application using the AddApplicationReferenceDataSource, Amazon Kinesis Analytics assigns an ID. You can use the DescribeApplication operation to get the reference ID. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.reference_data_source.delete(
                ctx,
                application_name=value,
                current_application_version_id=value,
                reference_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.reference_data_source.delete application_name=value, current_application_version_id=value, reference_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="delete_application_reference_data_source",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "ReferenceId": reference_id,
        },
    )
