"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    input_id: str,
    input_processing_configuration: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Adds an InputProcessingConfiguration to an application. An input processor preprocesses records on the input stream before the application's SQL code executes. Currently, the only input processor available is AWS Lambda.

    Args:
        application_name(str): Name of the application to which you want to add the input processing configuration.
        current_application_version_id(int): Version of the application to which you want to add the input processing configuration. You can use the DescribeApplication operation to get the current application version. If the version specified is not the current version, the ConcurrentModificationException is returned.
        input_id(str): The ID of the input configuration to add the input processing configuration to. You can get a list of the input IDs for an application using the DescribeApplication operation.
        input_processing_configuration(Dict): The InputProcessingConfiguration to add to the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.input_.processing_configuration.add(
                ctx,
                application_name=value,
                current_application_version_id=value,
                input_id=value,
                input_processing_configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.input_.processing_configuration.add application_name=value, current_application_version_id=value, input_id=value, input_processing_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="add_application_input_processing_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "InputId": input_id,
            "InputProcessingConfiguration": input_processing_configuration,
        },
    )


async def delete(
    hub, ctx, application_name: str, current_application_version_id: int, input_id: str
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Deletes an InputProcessingConfiguration from an input.

    Args:
        application_name(str): The Kinesis Analytics application name.
        current_application_version_id(int): The version ID of the Kinesis Analytics application.
        input_id(str): The ID of the input configuration from which to delete the input processing configuration. You can get a list of the input IDs for an application by using the DescribeApplication operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.input_.processing_configuration.delete(
                ctx, application_name=value, current_application_version_id=value, input_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.input_.processing_configuration.delete application_name=value, current_application_version_id=value, input_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="delete_application_input_processing_configuration",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "InputId": input_id,
        },
    )
