"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_name: str,
    application_description: str = None,
    inputs: List = None,
    outputs: List = None,
    cloud_watch_logging_options: List = None,
    application_code: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.   Creates an Amazon Kinesis Analytics application. You can configure each application with one streaming source as input, application code to process the input, and up to three destinations where you want Amazon Kinesis Analytics to write the output data from your application. For an overview, see How it Works.  In the input configuration, you map the streaming source to an in-application stream, which you can think of as a constantly updating table. In the mapping, you must provide a schema for the in-application stream and map each data column in the in-application stream to a data element in the streaming source. Your application code is one or more SQL statements that read input data, transform it, and generate output. Your application code can create one or more SQL artifacts like SQL streams or pumps. In the output configuration, you can configure the application to write data from in-application streams created in your applications to up to three destinations.  To read data from your source stream or write data to destination streams, Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating IAM roles. This operation requires permissions to perform the kinesisanalytics:CreateApplication action.   For introductory exercises to create an Amazon Kinesis Analytics application, see Getting Started.

    Args:
        application_name(str): Name of your Amazon Kinesis Analytics application (for example, sample-app).
        application_description(str, optional): Summary description of the application. Defaults to None.
        inputs(List, optional): Use this parameter to configure the application input. You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table). For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf. To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream. Defaults to None.
        outputs(List, optional): You can configure application output to write data from any of the in-application streams to up to three destinations. These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any combination of the three. In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf. In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf. Defaults to None.
        cloud_watch_logging_options(List, optional): Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more information, see Working with Amazon CloudWatch Logs. Defaults to None.
        application_code(str, optional): One or more SQL statements that read input data, transform it, and generate output. For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see Application Code.  You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps. Note that the application code must create the streams with names specified in the Outputs. For example, if your Outputs defines output streams named ExampleOutputStream1 and ExampleOutputStream2, then your application code must create these streams. . Defaults to None.
        tags(List, optional): A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see Using Tagging. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.create(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.create application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="create_application",
        op_kwargs={
            "ApplicationName": application_name,
            "ApplicationDescription": application_description,
            "Inputs": inputs,
            "Outputs": outputs,
            "CloudWatchLoggingOptions": cloud_watch_logging_options,
            "ApplicationCode": application_code,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, application_name: str, create_timestamp: str) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Deletes the specified application. Amazon Kinesis Analytics halts application execution and deletes the application, including any application artifacts (such as in-application streams, reference table, and application code). This operation requires permissions to perform the kinesisanalytics:DeleteApplication action.

    Args:
        application_name(str): Name of the Amazon Kinesis Analytics application to delete.
        create_timestamp(str):  You can use the DescribeApplication operation to get this value. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.delete(
                ctx, application_name=value, create_timestamp=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.delete application_name=value, create_timestamp=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="delete_application",
        op_kwargs={
            "ApplicationName": application_name,
            "CreateTimestamp": create_timestamp,
        },
    )


async def describe(hub, ctx, application_name: str) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Returns information about a specific Amazon Kinesis Analytics application. If you want to retrieve a list of all applications in your account, use the ListApplications operation. This operation requires permissions to perform the kinesisanalytics:DescribeApplication action. You can use DescribeApplication to get the current application versionId, which you need to call other operations such as Update.

    Args:
        application_name(str): Name of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.describe(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.describe application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="describe_application",
        op_kwargs={"ApplicationName": application_name},
    )


async def list_all(
    hub, ctx, limit: int = None, exclusive_start_application_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Returns a list of Amazon Kinesis Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status. If the response returns the HasMoreApplications value as true, you can send another request by adding the ExclusiveStartApplicationName in the request body, and set the value of this to the last application name from the previous response.  If you want detailed information about a specific application, use DescribeApplication. This operation requires permissions to perform the kinesisanalytics:ListApplications action.

    Args:
        limit(int, optional): Maximum number of applications to list. Defaults to None.
        exclusive_start_application_name(str, optional): Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="list_applications",
        op_kwargs={
            "Limit": limit,
            "ExclusiveStartApplicationName": exclusive_start_application_name,
        },
    )


async def start(hub, ctx, application_name: str, input_configurations: List) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Starts the specified Amazon Kinesis Analytics application. After creating an application, you must exclusively call this operation to start your application. After the application starts, it begins consuming the input data, processes it, and writes the output to the configured destination.  The application status must be READY for you to start an application. You can get the application status in the console or using the DescribeApplication operation. After you start the application, you can stop the application from processing the input by calling the StopApplication operation. This operation requires permissions to perform the kinesisanalytics:StartApplication action.

    Args:
        application_name(str): Name of the application.
        input_configurations(List): Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.start(
                ctx, application_name=value, input_configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.start application_name=value, input_configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="start_application",
        op_kwargs={
            "ApplicationName": application_name,
            "InputConfigurations": input_configurations,
        },
    )


async def stop(hub, ctx, application_name: str) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Stops the application from processing input data. You can stop an application only if it is in the running state. You can use the DescribeApplication operation to find the application state. After the application is stopped, Amazon Kinesis Analytics stops reading data from the input, the application stops processing data, and there is no output written to the destination.  This operation requires permissions to perform the kinesisanalytics:StopApplication action.

    Args:
        application_name(str): Name of the running application to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.stop(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.stop application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="stop_application",
        op_kwargs={"ApplicationName": application_name},
    )


async def update(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    application_update: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Updates an existing Amazon Kinesis Analytics application. Using this API, you can update application code, input configuration, and output configuration.  Note that Amazon Kinesis Analytics updates the CurrentApplicationVersionId each time you update your application.  This operation requires permission for the kinesisanalytics:UpdateApplication action.

    Args:
        application_name(str): Name of the Amazon Kinesis Analytics application to update.
        current_application_version_id(int): The current application version ID. You can use the DescribeApplication operation to get this value.
        application_update(Dict): Describes application updates.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.init.update(
                ctx,
                application_name=value,
                current_application_version_id=value,
                application_update=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.init.update application_name=value, current_application_version_id=value, application_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="update_application",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "ApplicationUpdate": application_update,
        },
    )
