"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    cloud_watch_logging_option: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Adds a CloudWatch log stream to monitor application configuration errors. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see Working with Amazon CloudWatch Logs.

    Args:
        application_name(str): The Kinesis Analytics application name.
        current_application_version_id(int): The version ID of the Kinesis Analytics application.
        cloud_watch_logging_option(Dict): Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role that is used must have the PutLogEvents policy action enabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.cloud_watch_logging_option.add(
                ctx,
                application_name=value,
                current_application_version_id=value,
                cloud_watch_logging_option=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.cloud_watch_logging_option.add application_name=value, current_application_version_id=value, cloud_watch_logging_option=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="add_application_cloud_watch_logging_option",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "CloudWatchLoggingOption": cloud_watch_logging_option,
        },
    )


async def delete(
    hub,
    ctx,
    application_name: str,
    current_application_version_id: int,
    cloud_watch_logging_option_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

     This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see Amazon Kinesis Data Analytics API V2 Documentation.  Deletes a CloudWatch log stream from an application. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see Working with Amazon CloudWatch Logs.

    Args:
        application_name(str): The Kinesis Analytics application name.
        current_application_version_id(int): The version ID of the Kinesis Analytics application.
        cloud_watch_logging_option_id(str): The CloudWatchLoggingOptionId of the CloudWatch logging option to delete. You can get the CloudWatchLoggingOptionId by using the DescribeApplication operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesisanalytic.application.cloud_watch_logging_option.delete(
                ctx,
                application_name=value,
                current_application_version_id=value,
                cloud_watch_logging_option_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesisanalytic.application.cloud_watch_logging_option.delete application_name=value, current_application_version_id=value, cloud_watch_logging_option_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesisanalytics",
        operation="delete_application_cloud_watch_logging_option",
        op_kwargs={
            "ApplicationName": application_name,
            "CurrentApplicationVersionId": current_application_version_id,
            "CloudWatchLoggingOptionId": cloud_watch_logging_option_id,
        },
    )
