"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    channel_arn: str,
    client_id: str = None,
    service: str = None,
    username: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Interactive Connectivity Establishment (ICE) server configuration information, including URIs, username, and password which can be used to configure the WebRTC connection. The ICE component uses this configuration information to setup the WebRTC connection, including authenticating with the Traversal Using Relays around NAT (TURN) relay server.  TURN is a protocol that is used to improve the connectivity of peer-to-peer applications. By providing a cloud-based relay service, TURN ensures that a connection can be established even when one or more peers are incapable of a direct peer-to-peer connection. For more information, see A REST API For Access To TURN Services.  You can invoke this API to establish a fallback mechanism in case either of the peers is unable to establish a direct peer-to-peer connection over a signaling channel. You must specify either a signaling channel ARN or the client ID in order to invoke this API.

    Args:
        channel_arn(str): The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers. .
        client_id(str, optional): Unique identifier for the viewer. Must be unique within the signaling channel. Defaults to None.
        service(str, optional): Specifies the desired service. Currently, TURN is the only valid value. Defaults to None.
        username(str, optional): An optional user ID to be associated with the credentials. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis_video_signaling.ice_server_config.get(
                ctx, channel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis_video_signaling.ice_server_config.get channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis-video-signaling",
        operation="get_ice_server_config",
        op_kwargs={
            "ChannelARN": channel_arn,
            "ClientId": client_id,
            "Service": service,
            "Username": username,
        },
    )
