"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "media_for_fragment_list"


async def get(
    hub, ctx, fragments: List, stream_name: str = None, stream_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets media for a list of fragments (specified by fragment number) from the archived data in an Amazon Kinesis video stream.  You must first call the GetDataEndpoint API to get an endpoint. Then send the GetMediaForFragmentList requests to this endpoint using the --endpoint-url parameter.   For limits, see Kinesis Video Streams Limits.  If an error is thrown after invoking a Kinesis Video Streams archived media API, in addition to the HTTP status code and the response body, it includes the following pieces of information:     x-amz-ErrorType HTTP header – contains a more specific error type in addition to what the HTTP status code provides.     x-amz-RequestId HTTP header – if you want to report an issue to AWS, the support team can better diagnose the problem if given the Request Id.   Both the HTTP status code and the ErrorType header can be utilized to make programmatic decisions about whether errors are retry-able and under what conditions, as well as provide information on what actions the client programmer might need to take in order to successfully try again. For more information, see the Errors section at the bottom of this topic, as well as Common Errors.

    Args:
        stream_name(str, optional): The name of the stream from which to retrieve fragment media. Specify either this parameter or the StreamARN parameter. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream from which to retrieve fragment media. Specify either this parameter or the StreamName parameter. Defaults to None.
        fragments(List): A list of the numbers of fragments for which to retrieve media. You retrieve these values with ListFragments.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis_video_archived_media.media_for_fragment_list_.get(
                ctx, fragments=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis_video_archived_media.media_for_fragment_list.get fragments=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis-video-archived-media",
        operation="get_media_for_fragment_list",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "Fragments": fragments,
        },
    )
