"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    stream_name: str = None,
    stream_arn: str = None,
    max_results: int = None,
    next_token: str = None,
    fragment_selector: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Fragment objects from the specified stream and timestamp range within the archived data. Listing fragments is eventually consistent. This means that even if the producer receives an acknowledgment that a fragment is persisted, the result might not be returned immediately from a request to ListFragments. However, results are typically available in less than one second.  You must first call the GetDataEndpoint API to get an endpoint. Then send the ListFragments requests to this endpoint using the --endpoint-url parameter.    If an error is thrown after invoking a Kinesis Video Streams archived media API, in addition to the HTTP status code and the response body, it includes the following pieces of information:     x-amz-ErrorType HTTP header – contains a more specific error type in addition to what the HTTP status code provides.     x-amz-RequestId HTTP header – if you want to report an issue to AWS, the support team can better diagnose the problem if given the Request Id.   Both the HTTP status code and the ErrorType header can be utilized to make programmatic decisions about whether errors are retry-able and under what conditions, as well as provide information on what actions the client programmer might need to take in order to successfully try again. For more information, see the Errors section at the bottom of this topic, as well as Common Errors.

    Args:
        stream_name(str, optional): The name of the stream from which to retrieve a fragment list. Specify either this parameter or the StreamARN parameter. Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream from which to retrieve a fragment list. Specify either this parameter or the StreamName parameter. Defaults to None.
        max_results(int, optional): The total number of fragments to return. If the total number of fragments available is more than the value specified in max-results, then a ListFragmentsOutput$NextToken is provided in the output that you can use to resume pagination. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the ListFragmentsOutput$NextToken from a previously truncated response. Defaults to None.
        fragment_selector(Dict, optional): Describes the timestamp range and timestamp origin for the range of fragments to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis_video_archived_media.fragment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis_video_archived_media.fragment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis-video-archived-media",
        operation="list_fragments",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "FragmentSelector": fragment_selector,
        },
    )
