"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    clip_fragment_selector: Dict,
    stream_name: str = None,
    stream_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Downloads an MP4 file (clip) containing the archived, on-demand media from the specified video stream over the specified time range.  Both the StreamName and the StreamARN parameters are optional, but you must specify either the StreamName or the StreamARN when invoking this API operation.  As a prerequisite to using GetCLip API, you must obtain an endpoint using GetDataEndpoint, specifying GET_CLIP for the APIName parameter.  An Amazon Kinesis video stream has the following requirements for providing data through MP4:   The media must contain h.264 or h.265 encoded video and, optionally, AAC or G.711 encoded audio. Specifically, the codec ID of track 1 should be V_MPEG/ISO/AVC (for h.264) or V_MPEGH/ISO/HEVC (for H.265). Optionally, the codec ID of track 2 should be A_AAC (for AAC) or A_MS/ACM (for G.711).   Data retention must be greater than 0.   The video track of each fragment must contain codec private data in the Advanced Video Coding (AVC) for H.264 format and HEVC for H.265 format. For more information, see MPEG-4 specification ISO/IEC 14496-15. For information about adapting stream data to a given format, see NAL Adaptation Flags.   The audio track (if present) of each fragment must contain codec private data in the AAC format (AAC specification ISO/IEC 13818-7) or the MS Wave format.   You can monitor the amount of outgoing data by monitoring the GetClip.OutgoingBytes Amazon CloudWatch metric. For information about using CloudWatch to monitor Kinesis Video Streams, see Monitoring Kinesis Video Streams. For pricing information, see Amazon Kinesis Video Streams Pricing and AWS Pricing. Charges for outgoing AWS data apply.

    Args:
        stream_name(str, optional): The name of the stream for which to retrieve the media clip.  You must specify either the StreamName or the StreamARN. . Defaults to None.
        stream_arn(str, optional): The Amazon Resource Name (ARN) of the stream for which to retrieve the media clip.  You must specify either the StreamName or the StreamARN. . Defaults to None.
        clip_fragment_selector(Dict): The time range of the requested clip and the source of the timestamps.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis_video_archived_media.clip.get(
                ctx, clip_fragment_selector=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis_video_archived_media.clip.get clip_fragment_selector=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis-video-archived-media",
        operation="get_clip",
        op_kwargs={
            "StreamName": stream_name,
            "StreamARN": stream_arn,
            "ClipFragmentSelector": clip_fragment_selector,
        },
    )
