"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def subscribe(
    hub, ctx, consumer_arn: str, shard_id: str, starting_position: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    This operation establishes an HTTP/2 connection between the consumer you specify in the ConsumerARN parameter and the shard you specify in the ShardId parameter. After the connection is successfully established, Kinesis Data Streams pushes records from the shard to the consumer over this connection. Before you call this operation, call RegisterStreamConsumer to register the consumer with Kinesis Data Streams. When the SubscribeToShard call succeeds, your consumer starts receiving events of type SubscribeToShardEvent over the HTTP/2 connection for up to 5 minutes, after which time you need to call SubscribeToShard again to renew the subscription if you want to continue to receive records. You can make one call to SubscribeToShard per second per registered consumer per shard. For example, if you have a 4000 shard stream and two registered stream consumers, you can make one SubscribeToShard request per second for each combination of shard and registered consumer, allowing you to subscribe both consumers to all 4000 shards in one second.  If you call SubscribeToShard again with the same ConsumerARN and ShardId within 5 seconds of a successful call, you'll get a ResourceInUseException. If you call SubscribeToShard 5 seconds or more after a successful call, the first connection will expire and the second call will take over the subscription. For an example of how to use this operations, see Enhanced Fan-Out Using the Kinesis Data Streams API.

    Args:
        consumer_arn(str): For this parameter, use the value you obtained when you called RegisterStreamConsumer.
        shard_id(str): The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use ListShards.
        starting_position(Dict): .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.to_shard.subscribe(
                ctx, consumer_arn=value, shard_id=value, starting_position=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.to_shard.subscribe consumer_arn=value, shard_id=value, starting_position=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="subscribe_to_shard",
        op_kwargs={
            "ConsumerARN": consumer_arn,
            "ShardId": shard_id,
            "StartingPosition": starting_position,
        },
    )
