"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(hub, ctx, stream_name: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Adds or updates tags for the specified Kinesis data stream. Each time you invoke this operation, you can specify up to 10 tags. If you want to add more than 10 tags to your stream, you can invoke this operation multiple times. In total, each stream can have up to 50 tags. If tags have already been assigned to the stream, AddTagsToStream overwrites any existing tags that correspond to the specified tag keys.  AddTagsToStream has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream.
        tags(Dict): A set of up to 10 key-value pairs to use to create the tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.tags.to_stream.add(ctx, stream_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.tags.to_stream.add stream_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="add_tags_to_stream",
        op_kwargs={"StreamName": stream_name, "Tags": tags},
    )
