"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def remove(hub, ctx, stream_name: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes tags from the specified Kinesis data stream. Removed tags are deleted and cannot be recovered after this operation successfully completes. If you specify a tag that does not exist, it is ignored.  RemoveTagsFromStream has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream.
        tag_keys(List): A list of tag keys. Each corresponding tag is removed from the stream.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.tags.from_stream.remove(
                ctx, stream_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.tags.from_stream.remove stream_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="remove_tags_from_stream",
        op_kwargs={"StreamName": stream_name, "TagKeys": tag_keys},
    )
