"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, stream_name: str, exclusive_start_tag_key: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags for the specified Kinesis data stream. This operation has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream.
        exclusive_start_tag_key(str, optional): The key to use as the starting point for the list of tags. If this parameter is set, ListTagsForStream gets all tags that occur after ExclusiveStartTagKey. . Defaults to None.
        limit(int, optional): The number of tags to return. If this number is less than the total number of tags associated with the stream, HasMoreTags is set to true. To list additional tags, set ExclusiveStartTagKey to the last key in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.tags.for_stream.list(ctx, stream_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.tags.for_stream.list stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="list_tags_for_stream",
        op_kwargs={
            "StreamName": stream_name,
            "ExclusiveStartTagKey": exclusive_start_tag_key,
            "Limit": limit,
        },
    )
