"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, stream_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a summarized description of the specified Kinesis data stream without the shard list. The information returned includes the stream name, Amazon Resource Name (ARN), status, record retention period, approximate creation time, monitoring, encryption details, and open shard count.   DescribeStreamSummary has a limit of 20 transactions per second per account.

    Args:
        stream_name(str): The name of the stream to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.summary.describe(ctx, stream_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.summary.describe stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="describe_stream_summary",
        op_kwargs={"StreamName": stream_name},
    )
