"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def decrease(hub, ctx, stream_name: str, retention_period_hours: int) -> None:
    r"""
    **Autogenerated function**

    Decreases the Kinesis data stream's retention period, which is the length of time data records are accessible after they are added to the stream. The minimum value of a stream's retention period is 24 hours. This operation may result in lost data. For example, if the stream's retention period is 48 hours and is decreased to 24 hours, any data already in the stream that is older than 24 hours is inaccessible.

    Args:
        stream_name(str): The name of the stream to modify.
        retention_period_hours(int): The new retention period of the stream, in hours. Must be less than the current retention period.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.retention_period.decrease(
                ctx, stream_name=value, retention_period_hours=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.retention_period.decrease stream_name=value, retention_period_hours=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="decrease_stream_retention_period",
        op_kwargs={
            "StreamName": stream_name,
            "RetentionPeriodHours": retention_period_hours,
        },
    )


async def increase(hub, ctx, stream_name: str, retention_period_hours: int) -> None:
    r"""
    **Autogenerated function**

    Increases the Kinesis data stream's retention period, which is the length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 168 hours (7 days). If you choose a longer stream retention period, this operation increases the time period during which records that have not yet expired are accessible. However, it does not make previous, expired data (older than the stream's previous retention period) accessible after the operation has been called. For example, if a stream's retention period is set to 24 hours and is increased to 168 hours, any data that is older than 24 hours remains inaccessible to consumer applications.

    Args:
        stream_name(str): The name of the stream to modify.
        retention_period_hours(int): The new retention period of the stream, in hours. Must be more than the current retention period.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.retention_period.increase(
                ctx, stream_name=value, retention_period_hours=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.retention_period.increase stream_name=value, retention_period_hours=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="increase_stream_retention_period",
        op_kwargs={
            "StreamName": stream_name,
            "RetentionPeriodHours": retention_period_hours,
        },
    )
