"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, stream_name: str, shard_count: int) -> None:
    r"""
    **Autogenerated function**

    Creates a Kinesis data stream. A stream captures and transports data records that are continuously emitted from different data sources or producers. Scale-out within a stream is explicitly supported by means of shards, which are uniquely identified groups of data records in a stream. You specify and control the number of shards that a stream is composed of. Each shard can support reads up to five transactions per second, up to a maximum data read total of 2 MiB per second. Each shard can support writes up to 1,000 records per second, up to a maximum data write total of 1 MiB per second. If the amount of data input increases or decreases, you can add or remove shards. The stream name identifies the stream. The name is scoped to the AWS account used by the application. It is also scoped by AWS Region. That is, two streams in two different accounts can have the same name, and two streams in the same account, but in two different Regions, can have the same name.  CreateStream is an asynchronous operation. Upon receiving a CreateStream request, Kinesis Data Streams immediately returns and sets the stream status to CREATING. After the stream is created, Kinesis Data Streams sets the stream status to ACTIVE. You should perform read and write operations only on an ACTIVE stream.  You receive a LimitExceededException when making a CreateStream request when you try to do one of the following:   Have more than five streams in the CREATING state at any point in time.   Create more shards than are authorized for your account.   For the default shard limit for an AWS account, see Amazon Kinesis Data Streams Limits in the Amazon Kinesis Data Streams Developer Guide. To increase this limit, contact AWS Support. You can use DescribeStream to check the stream status, which is returned in StreamStatus.  CreateStream has a limit of five transactions per second per account.

    Args:
        stream_name(str): A name to identify the stream. The stream name is scoped to the AWS account used by the application that creates the stream. It is also scoped by AWS Region. That is, two streams in two different AWS accounts can have the same name. Two streams in the same AWS account but in two different Regions can also have the same name.
        shard_count(int): The number of shards that the stream will use. The throughput of the stream is a function of the number of shards; more shards are required for greater provisioned throughput.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.init.create(
                ctx, stream_name=value, shard_count=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.init.create stream_name=value, shard_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="create_stream",
        op_kwargs={"StreamName": stream_name, "ShardCount": shard_count},
    )


async def delete(
    hub, ctx, stream_name: str, enforce_consumer_deletion: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes a Kinesis data stream and all its shards and data. You must shut down any applications that are operating on the stream before you delete the stream. If an application attempts to operate on a deleted stream, it receives the exception ResourceNotFoundException. If the stream is in the ACTIVE state, you can delete it. After a DeleteStream request, the specified stream is in the DELETING state until Kinesis Data Streams completes the deletion.  Note: Kinesis Data Streams might continue to accept data read and write operations, such as PutRecord, PutRecords, and GetRecords, on a stream in the DELETING state until the stream deletion is complete. When you delete a stream, any shards in that stream are also deleted, and any tags are dissociated from the stream. You can use the DescribeStream operation to check the state of the stream, which is returned in StreamStatus.  DeleteStream has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream to delete.
        enforce_consumer_deletion(bool, optional): If this parameter is unset (null) or if you set it to false, and the stream has registered consumers, the call to DeleteStream fails with a ResourceInUseException. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.init.delete(ctx, stream_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.init.delete stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="delete_stream",
        op_kwargs={
            "StreamName": stream_name,
            "EnforceConsumerDeletion": enforce_consumer_deletion,
        },
    )


async def describe(
    hub, ctx, stream_name: str, limit: int = None, exclusive_start_shard_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Kinesis data stream. The information returned includes the stream name, Amazon Resource Name (ARN), creation time, enhanced metric configuration, and shard map. The shard map is an array of shard objects. For each shard object, there is the hash key and sequence number ranges that the shard spans, and the IDs of any earlier shards that played in a role in creating the shard. Every record ingested in the stream is identified by a sequence number, which is assigned when the record is put into the stream. You can limit the number of shards returned by each call. For more information, see Retrieving Shards from a Stream in the Amazon Kinesis Data Streams Developer Guide. There are no guarantees about the chronological order shards returned. To process shards in chronological order, use the ID of the parent shard to track the lineage to the oldest shard. This operation has a limit of 10 transactions per second per account.

    Args:
        stream_name(str): The name of the stream to describe.
        limit(int, optional): The maximum number of shards to return in a single call. The default value is 100. If you specify a value greater than 100, at most 100 shards are returned. Defaults to None.
        exclusive_start_shard_id(str, optional): The shard ID of the shard to start with. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.init.describe(ctx, stream_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.init.describe stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="describe_stream",
        op_kwargs={
            "StreamName": stream_name,
            "Limit": limit,
            "ExclusiveStartShardId": exclusive_start_shard_id,
        },
    )


async def list_all(
    hub, ctx, limit: int = None, exclusive_start_stream_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your Kinesis data streams. The number of streams may be too large to return from a single call to ListStreams. You can limit the number of returned streams using the Limit parameter. If you do not specify a value for the Limit parameter, Kinesis Data Streams uses the default limit, which is currently 10. You can detect if there are more streams available to list by using the HasMoreStreams flag from the returned output. If there are more streams available, you can request more streams by using the name of the last stream returned by the ListStreams request in the ExclusiveStartStreamName parameter in a subsequent request to ListStreams. The group of stream names returned by the subsequent request is then added to the list. You can continue this process until all the stream names have been collected in the list.   ListStreams has a limit of five transactions per second per account.

    Args:
        limit(int, optional): The maximum number of streams to list. Defaults to None.
        exclusive_start_stream_name(str, optional): The name of the stream to start the list with. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="list_streams",
        op_kwargs={
            "Limit": limit,
            "ExclusiveStartStreamName": exclusive_start_stream_name,
        },
    )
