"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def start(hub, ctx, stream_name: str, encryption_type: str, key_id: str) -> None:
    r"""
    **Autogenerated function**

    Enables or updates server-side encryption using an AWS KMS key for a specified stream.  Starting encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns immediately and sets the status of the stream to UPDATING. After the update is complete, Kinesis Data Streams sets the status of the stream back to ACTIVE. Updating or applying encryption normally takes a few seconds to complete, but it can take minutes. You can continue to read and write data to your stream while its status is UPDATING. Once the status of the stream is ACTIVE, encryption begins for records written to the stream.  API Limits: You can successfully apply a new AWS KMS key for server-side encryption 25 times in a rolling 24-hour period. Note: It can take up to 5 seconds after the stream is in an ACTIVE status before all records written to the stream are encrypted. After you enable encryption, you can verify that encryption is applied by inspecting the API response from PutRecord or PutRecords.

    Args:
        stream_name(str): The name of the stream for which to start encrypting records.
        encryption_type(str): The encryption type to use. The only valid value is KMS.
        key_id(str): The GUID for the customer-managed AWS KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias aws/kinesis.   Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012    Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName    Globally unique key ID example: 12345678-1234-1234-1234-123456789012    Alias name example: alias/MyAliasName    Master key owned by Kinesis Data Streams: alias/aws/kinesis   .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.encryption.start(
                ctx, stream_name=value, encryption_type=value, key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.encryption.start stream_name=value, encryption_type=value, key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="start_stream_encryption",
        op_kwargs={
            "StreamName": stream_name,
            "EncryptionType": encryption_type,
            "KeyId": key_id,
        },
    )


async def stop(hub, ctx, stream_name: str, encryption_type: str, key_id: str) -> None:
    r"""
    **Autogenerated function**

    Disables server-side encryption for a specified stream.  Stopping encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns immediately and sets the status of the stream to UPDATING. After the update is complete, Kinesis Data Streams sets the status of the stream back to ACTIVE. Stopping encryption normally takes a few seconds to complete, but it can take minutes. You can continue to read and write data to your stream while its status is UPDATING. Once the status of the stream is ACTIVE, records written to the stream are no longer encrypted by Kinesis Data Streams.  API Limits: You can successfully disable server-side encryption 25 times in a rolling 24-hour period.  Note: It can take up to 5 seconds after the stream is in an ACTIVE status before all records written to the stream are no longer subject to encryption. After you disabled encryption, you can verify that encryption is not applied by inspecting the API response from PutRecord or PutRecords.

    Args:
        stream_name(str): The name of the stream on which to stop encrypting records.
        encryption_type(str): The encryption type. The only valid value is KMS.
        key_id(str): The GUID for the customer-managed AWS KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias aws/kinesis.   Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012    Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName    Globally unique key ID example: 12345678-1234-1234-1234-123456789012    Alias name example: alias/MyAliasName    Master key owned by Kinesis Data Streams: alias/aws/kinesis   .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.encryption.stop(
                ctx, stream_name=value, encryption_type=value, key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.encryption.stop stream_name=value, encryption_type=value, key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="stop_stream_encryption",
        op_kwargs={
            "StreamName": stream_name,
            "EncryptionType": encryption_type,
            "KeyId": key_id,
        },
    )
