"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(
    hub,
    ctx,
    stream_arn: str = None,
    consumer_name: str = None,
    consumer_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    To deregister a consumer, provide its ARN. Alternatively, you can provide the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the consumer that you want to deregister, you can use the ListStreamConsumers operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream. The description of a consumer contains its name and ARN. This operation has a limit of five transactions per second per stream.

    Args:
        stream_arn(str, optional): The ARN of the Kinesis data stream that the consumer is registered with. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces. Defaults to None.
        consumer_name(str, optional): The name that you gave to the consumer. Defaults to None.
        consumer_arn(str, optional): The ARN returned by Kinesis Data Streams when you registered the consumer. If you don't know the ARN of the consumer that you want to deregister, you can use the ListStreamConsumers operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream. The description of a consumer contains its ARN. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.consumer.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.consumer.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="deregister_stream_consumer",
        op_kwargs={
            "StreamARN": stream_arn,
            "ConsumerName": consumer_name,
            "ConsumerARN": consumer_arn,
        },
    )


async def describe(
    hub,
    ctx,
    stream_arn: str = None,
    consumer_name: str = None,
    consumer_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    To get the description of a registered consumer, provide the ARN of the consumer. Alternatively, you can provide the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the consumer that you want to describe, you can use the ListStreamConsumers operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream. This operation has a limit of 20 transactions per second per stream.

    Args:
        stream_arn(str, optional): The ARN of the Kinesis data stream that the consumer is registered with. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces. Defaults to None.
        consumer_name(str, optional): The name that you gave to the consumer. Defaults to None.
        consumer_arn(str, optional): The ARN returned by Kinesis Data Streams when you registered the consumer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.consumer.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.consumer.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="describe_stream_consumer",
        op_kwargs={
            "StreamARN": stream_arn,
            "ConsumerName": consumer_name,
            "ConsumerARN": consumer_arn,
        },
    )


async def list_all(
    hub,
    ctx,
    stream_arn: str,
    next_token: str = None,
    max_results: int = None,
    stream_creation_timestamp: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information about each consumer. This operation has a limit of 5 transactions per second per stream.

    Args:
        stream_arn(str): The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces.
        next_token(str, optional): When the number of consumers that are registered with the data stream is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of consumers that are registered with the data stream, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListStreamConsumers to list the next set of registered consumers. Don't specify StreamName or StreamCreationTimestamp if you specify NextToken because the latter unambiguously identifies the stream. You can optionally specify a value for the MaxResults parameter when you specify NextToken. If you specify a MaxResults value that is less than the number of consumers that the operation returns if you don't specify MaxResults, the response will contain a new NextToken value. You can use the new NextToken value in a subsequent call to the ListStreamConsumers operation to list the next set of consumers.  Tokens expire after 300 seconds. When you obtain a value for NextToken in the response to a call to ListStreamConsumers, you have 300 seconds to use that value. If you specify an expired token in a call to ListStreamConsumers, you get ExpiredNextTokenException. . Defaults to None.
        max_results(int, optional): The maximum number of consumers that you want a single call of ListStreamConsumers to return. Defaults to None.
        stream_creation_timestamp(str, optional): Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the consumers for.  You can't specify this parameter if you specify the NextToken parameter. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.consumer.list_all(ctx, stream_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.consumer.list_all stream_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="list_stream_consumers",
        op_kwargs={
            "StreamARN": stream_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
            "StreamCreationTimestamp": stream_creation_timestamp,
        },
    )


async def register(hub, ctx, stream_arn: str, consumer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a consumer with a Kinesis data stream. When you use this operation, the consumer you register can then call SubscribeToShard to receive data from the stream using enhanced fan-out, at a rate of up to 2 MiB per second for every shard you subscribe to. This rate is unaffected by the total number of consumers that read from the same stream. You can register up to 20 consumers per stream. A given consumer can only be registered with one stream at a time. For an example of how to use this operations, see Enhanced Fan-Out Using the Kinesis Data Streams API. The use of this operation has a limit of five transactions per second per account. Also, only 5 consumers can be created simultaneously. In other words, you cannot have more than 5 consumers in a CREATING status at the same time. Registering a 6th consumer while there are 5 in a CREATING status results in a LimitExceededException.

    Args:
        stream_arn(str): The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see Amazon Resource Names (ARNs) and AWS Service Namespaces.
        consumer_name(str): For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to be unique across data streams.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.stream.consumer.register(
                ctx, stream_arn=value, consumer_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.stream.consumer.register stream_arn=value, consumer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="register_stream_consumer",
        op_kwargs={"StreamARN": stream_arn, "ConsumerName": consumer_name},
    )
