"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    stream_name: str = None,
    next_token: str = None,
    exclusive_start_shard_id: str = None,
    max_results: int = None,
    stream_creation_timestamp: str = None,
    shard_filter: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the shards in a stream and provides information about each shard. This operation has a limit of 100 transactions per second per data stream.  This API is a new operation that is used by the Amazon Kinesis Client Library (KCL). If you have a fine-grained IAM policy that only allows specific operations, you must update your policy to allow calls to this API. For more information, see Controlling Access to Amazon Kinesis Data Streams Resources Using IAM.

    Args:
        stream_name(str, optional): The name of the data stream whose shards you want to list.  You cannot specify this parameter if you specify the NextToken parameter. Defaults to None.
        next_token(str, optional): When the number of shards in the data stream is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of shards in the data stream, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListShards to list the next set of shards. Don't specify StreamName or StreamCreationTimestamp if you specify NextToken because the latter unambiguously identifies the stream. You can optionally specify a value for the MaxResults parameter when you specify NextToken. If you specify a MaxResults value that is less than the number of shards that the operation returns if you don't specify MaxResults, the response will contain a new NextToken value. You can use the new NextToken value in a subsequent call to the ListShards operation.  Tokens expire after 300 seconds. When you obtain a value for NextToken in the response to a call to ListShards, you have 300 seconds to use that value. If you specify an expired token in a call to ListShards, you get ExpiredNextTokenException. . Defaults to None.
        exclusive_start_shard_id(str, optional): Specify this parameter to indicate that you want to list the shards starting with the shard whose ID immediately follows ExclusiveStartShardId. If you don't specify this parameter, the default behavior is for ListShards to list the shards starting with the first one in the stream. You cannot specify this parameter if you specify NextToken. Defaults to None.
        max_results(int, optional): The maximum number of shards to return in a single call to ListShards. The minimum value you can specify for this parameter is 1, and the maximum is 10,000, which is also the default. When the number of shards to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListShards to list the next set of shards. Defaults to None.
        stream_creation_timestamp(str, optional): Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the shards for. You cannot specify this parameter if you specify the NextToken parameter. Defaults to None.
        shard_filter(Dict, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.shard.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.shard.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="list_shards",
        op_kwargs={
            "StreamName": stream_name,
            "NextToken": next_token,
            "ExclusiveStartShardId": exclusive_start_shard_id,
            "MaxResults": max_results,
            "StreamCreationTimestamp": stream_creation_timestamp,
            "ShardFilter": shard_filter,
        },
    )


async def merge(
    hub, ctx, stream_name: str, shard_to_merge: str, adjacent_shard_to_merge: str
) -> None:
    r"""
    **Autogenerated function**

    Merges two adjacent shards in a Kinesis data stream and combines them into a single shard to reduce the stream's capacity to ingest and transport data. Two shards are considered adjacent if the union of the hash key ranges for the two shards form a contiguous set with no gaps. For example, if you have two shards, one with a hash key range of 276...381 and the other with a hash key range of 382...454, then you could merge these two shards into a single shard that would have a hash key range of 276...454. After the merge, the single child shard receives data for all hash key values covered by the two parent shards.  MergeShards is called when there is a need to reduce the overall capacity of a stream because of excess capacity that is not being used. You must specify the shard to be merged and the adjacent shard for a stream. For more information about merging shards, see Merge Two Shards in the Amazon Kinesis Data Streams Developer Guide. If the stream is in the ACTIVE state, you can call MergeShards. If a stream is in the CREATING, UPDATING, or DELETING state, MergeShards returns a ResourceInUseException. If the specified stream does not exist, MergeShards returns a ResourceNotFoundException.  You can use DescribeStream to check the state of the stream, which is returned in StreamStatus.  MergeShards is an asynchronous operation. Upon receiving a MergeShards request, Amazon Kinesis Data Streams immediately returns a response and sets the StreamStatus to UPDATING. After the operation is completed, Kinesis Data Streams sets the StreamStatus to ACTIVE. Read and write operations continue to work while the stream is in the UPDATING state.  You use DescribeStream to determine the shard IDs that are specified in the MergeShards request.  If you try to operate on too many streams in parallel using CreateStream, DeleteStream, MergeShards, or SplitShard, you receive a LimitExceededException.   MergeShards has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream for the merge.
        shard_to_merge(str): The shard ID of the shard to combine with the adjacent shard for the merge.
        adjacent_shard_to_merge(str): The shard ID of the adjacent shard for the merge.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.shard.init.merge(
                ctx, stream_name=value, shard_to_merge=value, adjacent_shard_to_merge=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.shard.init.merge stream_name=value, shard_to_merge=value, adjacent_shard_to_merge=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="merge_shards",
        op_kwargs={
            "StreamName": stream_name,
            "ShardToMerge": shard_to_merge,
            "AdjacentShardToMerge": adjacent_shard_to_merge,
        },
    )


async def split(
    hub, ctx, stream_name: str, shard_to_split: str, new_starting_hash_key: str
) -> None:
    r"""
    **Autogenerated function**

    Splits a shard into two new shards in the Kinesis data stream, to increase the stream's capacity to ingest and transport data. SplitShard is called when there is a need to increase the overall capacity of a stream because of an expected increase in the volume of data records being ingested.  You can also use SplitShard when a shard appears to be approaching its maximum utilization; for example, the producers sending data into the specific shard are suddenly sending more than previously anticipated. You can also call SplitShard to increase stream capacity, so that more Kinesis Data Streams applications can simultaneously read data from the stream for real-time processing.  You must specify the shard to be split and the new hash key, which is the position in the shard where the shard gets split in two. In many cases, the new hash key might be the average of the beginning and ending hash key, but it can be any hash key value in the range being mapped into the shard. For more information, see Split a Shard in the Amazon Kinesis Data Streams Developer Guide. You can use DescribeStream to determine the shard ID and hash key values for the ShardToSplit and NewStartingHashKey parameters that are specified in the SplitShard request.  SplitShard is an asynchronous operation. Upon receiving a SplitShard request, Kinesis Data Streams immediately returns a response and sets the stream status to UPDATING. After the operation is completed, Kinesis Data Streams sets the stream status to ACTIVE. Read and write operations continue to work while the stream is in the UPDATING state.  You can use DescribeStream to check the status of the stream, which is returned in StreamStatus. If the stream is in the ACTIVE state, you can call SplitShard. If a stream is in CREATING or UPDATING or DELETING states, DescribeStream returns a ResourceInUseException. If the specified stream does not exist, DescribeStream returns a ResourceNotFoundException. If you try to create more shards than are authorized for your account, you receive a LimitExceededException.  For the default shard limit for an AWS account, see Kinesis Data Streams Limits in the Amazon Kinesis Data Streams Developer Guide. To increase this limit, contact AWS Support. If you try to operate on too many streams simultaneously using CreateStream, DeleteStream, MergeShards, and/or SplitShard, you receive a LimitExceededException.   SplitShard has a limit of five transactions per second per account.

    Args:
        stream_name(str): The name of the stream for the shard split.
        shard_to_split(str): The shard ID of the shard to split.
        new_starting_hash_key(str): A hash key value for the starting hash key of one of the child shards created by the split. The hash key range for a given shard constitutes a set of ordered contiguous positive integers. The value for NewStartingHashKey must be in the range of hash keys being mapped into the shard. The NewStartingHashKey hash key value and all higher hash key values in hash key range are distributed to one of the child shards. All the lower hash key values in the range are distributed to the other child shard.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.shard.init.split(
                ctx, stream_name=value, shard_to_split=value, new_starting_hash_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.shard.init.split stream_name=value, shard_to_split=value, new_starting_hash_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="split_shard",
        op_kwargs={
            "StreamName": stream_name,
            "ShardToSplit": shard_to_split,
            "NewStartingHashKey": new_starting_hash_key,
        },
    )
