"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, stream_name: str, target_shard_count: int, scaling_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the shard count of the specified stream to the specified number of shards. Updating the shard count is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns immediately and sets the status of the stream to UPDATING. After the update is complete, Kinesis Data Streams sets the status of the stream back to ACTIVE. Depending on the size of the stream, the scaling action could take a few minutes to complete. You can continue to read and write data to your stream while its status is UPDATING. To update the shard count, Kinesis Data Streams performs splits or merges on individual shards. This can cause short-lived shards to be created, in addition to the final shards. These short-lived shards count towards your total shard limit for your account in the Region. When using this operation, we recommend that you specify a target shard count that is a multiple of 25% (25%, 50%, 75%, 100%). You can specify any target value within your shard limit. However, if you specify a target that isn't a multiple of 25%, the scaling action might take longer to complete.  This operation has the following default limits. By default, you cannot do the following:   Scale more than ten times per rolling 24-hour period per stream   Scale up to more than double your current shard count for a stream   Scale down below half your current shard count for a stream   Scale up to more than 500 shards in a stream   Scale a stream with more than 500 shards down unless the result is less than 500 shards   Scale up to more than the shard limit for your account   For the default limits for an AWS account, see Streams Limits in the Amazon Kinesis Data Streams Developer Guide. To request an increase in the call rate limit, the shard limit for this API, or your overall shard limit, use the limits form.

    Args:
        stream_name(str): The name of the stream.
        target_shard_count(int): The new number of shards. This value has the following default limits. By default, you cannot do the following:    Set this value to more than double your current shard count for a stream.   Set this value below half your current shard count for a stream.   Set this value to more than 500 shards in a stream (the default limit for shard count per stream is 500 per account per region), unless you request a limit increase.   Scale a stream with more than 500 shards down unless you set this value to less than 500 shards.  .
        scaling_type(str): The scaling type. Uniform scaling creates shards of equal size.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.shard.count.update(
                ctx, stream_name=value, target_shard_count=value, scaling_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.shard.count.update stream_name=value, target_shard_count=value, scaling_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="update_shard_count",
        op_kwargs={
            "StreamName": stream_name,
            "TargetShardCount": target_shard_count,
            "ScalingType": scaling_type,
        },
    )
