"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disable(hub, ctx, stream_name: str, shard_level_metrics: List) -> Dict:
    r"""
    **Autogenerated function**

    Disables enhanced monitoring.

    Args:
        stream_name(str): The name of the Kinesis data stream for which to disable enhanced monitoring.
        shard_level_metrics(List): List of shard-level metrics to disable. The following are the valid shard-level metrics. The value "ALL" disables every metric.    IncomingBytes     IncomingRecords     OutgoingBytes     OutgoingRecords     WriteProvisionedThroughputExceeded     ReadProvisionedThroughputExceeded     IteratorAgeMilliseconds     ALL    For more information, see Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch in the Amazon Kinesis Data Streams Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.enhanced_monitoring.disable(
                ctx, stream_name=value, shard_level_metrics=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.enhanced_monitoring.disable stream_name=value, shard_level_metrics=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="disable_enhanced_monitoring",
        op_kwargs={"StreamName": stream_name, "ShardLevelMetrics": shard_level_metrics},
    )


async def enable(hub, ctx, stream_name: str, shard_level_metrics: List) -> Dict:
    r"""
    **Autogenerated function**

    Enables enhanced Kinesis data stream monitoring for shard-level metrics.

    Args:
        stream_name(str): The name of the stream for which to enable enhanced monitoring.
        shard_level_metrics(List): List of shard-level metrics to enable. The following are the valid shard-level metrics. The value "ALL" enables every metric.    IncomingBytes     IncomingRecords     OutgoingBytes     OutgoingRecords     WriteProvisionedThroughputExceeded     ReadProvisionedThroughputExceeded     IteratorAgeMilliseconds     ALL    For more information, see Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch in the Amazon Kinesis Data Streams Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kinesis.enhanced_monitoring.enable(
                ctx, stream_name=value, shard_level_metrics=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kinesis.enhanced_monitoring.enable stream_name=value, shard_level_metrics=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kinesis",
        operation="enable_enhanced_monitoring",
        op_kwargs={"StreamName": stream_name, "ShardLevelMetrics": shard_level_metrics},
    )
