"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    index_id: str,
    name: str,
    role_arn: str,
    source_s3_path: Dict,
    description: str = None,
    tags: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.

    Args:
        index_id(str): The unique identifier of the index for the new thesaurus. .
        name(str): The name for the new thesaurus.
        description(str, optional): The description for the new thesaurus. Defaults to None.
        role_arn(str): An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus file specified in SourceS3Path. .
        tags(List, optional): A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. . Defaults to None.
        source_s3_path(Dict): The thesaurus file Amazon S3 source path. .
        client_token(str, optional): A token that you provide to identify the request to create a thesaurus. Multiple calls to the CreateThesaurus operation with the same client token will create only one index. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.thesaurus.create(
                ctx, index_id=value, name=value, role_arn=value, source_s3_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.thesaurus.create index_id=value, name=value, role_arn=value, source_s3_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="create_thesaurus",
        op_kwargs={
            "IndexId": index_id,
            "Name": name,
            "Description": description,
            "RoleArn": role_arn,
            "Tags": tags,
            "SourceS3Path": source_s3_path,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, id_: str, index_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Amazon Kendra thesaurus.

    Args:
        id_(str): The identifier of the thesaurus to delete.
        index_id(str): The identifier of the index associated with the thesaurus to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.thesaurus.delete(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.thesaurus.delete id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="delete_thesaurus",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def describe(hub, ctx, id_: str, index_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing Amazon Kendra thesaurus.

    Args:
        id_(str): The identifier of the thesaurus to describe.
        index_id(str): The identifier of the index associated with the thesaurus to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.thesaurus.describe(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.thesaurus.describe id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_thesaurus",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def update(
    hub,
    ctx,
    id_: str,
    index_id: str,
    name: str = None,
    description: str = None,
    role_arn: str = None,
    source_s3_path: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a thesaurus file associated with an index.

    Args:
        id_(str): The identifier of the thesaurus to update.
        name(str, optional): The updated name of the thesaurus. Defaults to None.
        index_id(str): The identifier of the index associated with the thesaurus to update.
        description(str, optional): The updated description of the thesaurus. Defaults to None.
        role_arn(str, optional): The updated role ARN of the thesaurus. Defaults to None.
        source_s3_path(Dict, optional): Information required to find a specific file in an Amazon S3 bucket. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.thesaurus.update(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.thesaurus.update id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="update_thesaurus",
        op_kwargs={
            "Id": id_,
            "Name": name,
            "IndexId": index_id,
            "Description": description,
            "RoleArn": role_arn,
            "SourceS3Path": source_s3_path,
        },
    )
