"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, index_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Kendra thesauri associated with an index.

    Args:
        index_id(str): The identifier of the index associated with the thesaurus to list.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (ThesaurusSummaryItems). . Defaults to None.
        max_results(int, optional): The maximum number of thesauri to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.thesauri.list(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.thesauri.list index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_thesauri",
        op_kwargs={
            "IndexId": index_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
