"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def clear(hub, ctx, index_id: str) -> None:
    r"""
    **Autogenerated function**

    Clears existing query suggestions from an index. This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.

    Args:
        index_id(str): The identifier of the index you want to clear query suggestions from.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.init.clear(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.init.clear index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="clear_query_suggestions",
        op_kwargs={"IndexId": index_id},
    )


async def get_all(
    hub, ctx, index_id: str, query_text: str, max_suggestions_count: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Fetches the queries that are suggested to your users.

    Args:
        index_id(str): The identifier of the index you want to get query suggestions from.
        query_text(str): The text of a user's query to generate query suggestions. A query is suggested if the query prefix matches what a user starts to type as their query. Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.
        max_suggestions_count(int, optional): The maximum number of query suggestions you want to show to your users. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.init.get_all(
                ctx, index_id=value, query_text=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.init.get_all index_id=value, query_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="get_query_suggestions",
        op_kwargs={
            "IndexId": index_id,
            "QueryText": query_text,
            "MaxSuggestionsCount": max_suggestions_count,
        },
    )
