"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, index_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the settings of query suggestions for an index. This is used to check the current settings applied to query suggestions.

    Args:
        index_id(str): The identifier of the index you want to describe query suggestions settings for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.config.describe(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.config.describe index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_query_suggestions_config",
        op_kwargs={"IndexId": index_id},
    )


async def update(
    hub,
    ctx,
    index_id: str,
    mode: str = None,
    query_log_look_back_window_in_days: int = None,
    include_queries_without_user_information: bool = None,
    minimum_number_of_querying_users: int = None,
    minimum_query_count: int = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the settings of query suggestions for an index. Amazon Kendra supports partial updates, so you only need to provide the fields you want to update. If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making another update. Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index. You can still enable/disable query suggestions at any time.

    Args:
        index_id(str): The identifier of the index you want to update query suggestions settings for.
        mode(str, optional): Set the mode to ENABLED or LEARN_ONLY. By default, Amazon Kendra enables query suggestions. LEARN_ONLY mode allows you to turn off query suggestions. You can to update this at any time. In LEARN_ONLY mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again. Defaults to None.
        query_log_look_back_window_in_days(int, optional): How recent your queries are in your query log time window. The time window is the number of days from current day to past days. By default, Amazon Kendra sets this to 180. Defaults to None.
        include_queries_without_user_information(bool, optional):  TRUE to include queries without user information (i.e. all queries, irrespective of the user), otherwise FALSE to only include queries with user information. If you pass user information to Amazon Kendra along with the queries, you can set this flag to FALSE and instruct Amazon Kendra to only consider queries with user information. If you set to FALSE, Amazon Kendra only considers queries searched at least MinimumQueryCount times across MinimumNumberOfQueryingUsers unique users for suggestions. If you set to TRUE, Amazon Kendra ignores all user information and learns from all queries. Defaults to None.
        minimum_number_of_querying_users(int, optional): The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users. Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users. How you tune this setting depends on your specific needs. Defaults to None.
        minimum_query_count(int, optional): The the minimum number of times a query must be searched in order to be eligible to suggest to your users. Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users. How you tune this setting depends on your specific needs. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.config.update(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.config.update index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="update_query_suggestions_config",
        op_kwargs={
            "IndexId": index_id,
            "Mode": mode,
            "QueryLogLookBackWindowInDays": query_log_look_back_window_in_days,
            "IncludeQueriesWithoutUserInformation": include_queries_without_user_information,
            "MinimumNumberOfQueryingUsers": minimum_number_of_querying_users,
            "MinimumQueryCount": minimum_query_count,
        },
    )
