"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "block_list"


async def create(
    hub,
    ctx,
    index_id: str,
    name: str,
    source_s3_path: Dict,
    role_arn: str,
    description: str = None,
    client_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a block list to exlcude certain queries from suggestions. Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion. You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line. For information on the current quota limits for block lists, see Quotas for Amazon Kendra.

    Args:
        index_id(str): The identifier of the index you want to create a query suggestions block list for.
        name(str): A user friendly name for the block list. For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.
        description(str, optional): A user-friendly description for the block list. For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions.". Defaults to None.
        source_s3_path(Dict): The S3 path to your block list text file in your S3 bucket. Each block word or phrase should be on a separate line in a text file. For information on the current quota limits for block lists, see Quotas for Amazon Kendra.
        client_token(str, optional): A token that you provide to identify the request to create a query suggestions block list. Defaults to None.
        role_arn(str): The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket. You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
        tags(List, optional): A tag that you can assign to a block list that categorizes the block list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.block_list_.create(
                ctx, index_id=value, name=value, source_s3_path=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.block_list.create index_id=value, name=value, source_s3_path=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="create_query_suggestions_block_list",
        op_kwargs={
            "IndexId": index_id,
            "Name": name,
            "Description": description,
            "SourceS3Path": source_s3_path,
            "ClientToken": client_token,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, index_id: str, id_: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a block list used for query suggestions for an index. A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.

    Args:
        index_id(str): The identifier of the you want to delete a block list from.
        id_(str): The unique identifier of the block list that needs to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.block_list_.delete(
                ctx, index_id=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.block_list.delete index_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="delete_query_suggestions_block_list",
        op_kwargs={"IndexId": index_id, "Id": id_},
    )


async def describe(hub, ctx, index_id: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a block list used for query suggestions for an index. This is used to check the current settings that are applied to a block list.

    Args:
        index_id(str): The identifier of the index for the block list.
        id_(str): The unique identifier of the block list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.block_list_.describe(
                ctx, index_id=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.block_list.describe index_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_query_suggestions_block_list",
        op_kwargs={"IndexId": index_id, "Id": id_},
    )


async def list_all(
    hub, ctx, index_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the block lists used for query suggestions for an index. For information on the current quota limits for block lists, see Quotas for Amazon Kendra.

    Args:
        index_id(str): The identifier of the index for a list of all block lists that exist for that index. For information on the current quota limits for block lists, see Quotas for Amazon Kendra.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (BlockListSummaryItems). Defaults to None.
        max_results(int, optional): The maximum number of block lists to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.block_list_.list_all(
                ctx, index_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.block_list.list_all index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_query_suggestions_block_lists",
        op_kwargs={
            "IndexId": index_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    index_id: str,
    id_: str,
    name: str = None,
    description: str = None,
    source_s3_path: Dict = None,
    role_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a block list used for query suggestions for an index. Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately. If a block list is updating, then you need to wait for the first update to finish before submitting another update. Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.

    Args:
        index_id(str): The identifier of the index for a block list.
        id_(str): The unique identifier of a block list.
        name(str, optional): The name of a block list. Defaults to None.
        description(str, optional): The description for a block list. Defaults to None.
        source_s3_path(Dict, optional): The S3 path where your block list text file sits in S3. If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the UpdateQuerySuggestionsBlockList API to refresh you block list. If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately. Defaults to None.
        role_arn(str, optional): The IAM (Identity and Access Management) role used to access the block list text file in S3. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.query_suggestion.block_list_.update(
                ctx, index_id=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.query_suggestion.block_list.update index_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="update_query_suggestions_block_list",
        op_kwargs={
            "IndexId": index_id,
            "Id": id_,
            "Name": name,
            "Description": description,
            "SourceS3Path": source_s3_path,
            "RoleArn": role_arn,
        },
    )
