"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, index_id: str, documents: List, role_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more documents to an index. The BatchPutDocument operation enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this operation to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index. The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log.

    Args:
        index_id(str): The identifier of the index to add the documents to. You need to create the index first using the CreateIndex operation.
        role_arn(str, optional): The Amazon Resource Name (ARN) of a role that is allowed to run the BatchPutDocument operation. For more information, see IAM Roles for Amazon Kendra. Defaults to None.
        documents(List): One or more documents to add to the index. Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job. Documents have the following file size limits.   5 MB total size for inline documents   50 MB total size for files from an S3 bucket   5 MB extracted text for any file   For more information about file size and transaction per second quotas, see Quotas.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.put_document.batch(ctx, index_id=value, documents=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.put_document.batch index_id=value, documents=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="batch_put_document",
        op_kwargs={"IndexId": index_id, "RoleArn": role_arn, "Documents": documents},
    )
