"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub,
    ctx,
    index_id: str,
    group_id: str,
    data_source_id: str = None,
    ordering_id: int = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results. If you want to delete or replace users or sub groups of a group, you need to use the PutPrincipalMapping operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling PutPrincipalMapping. You can update your internal list of users or sub groups and input this list when calling PutPrincipalMapping.

    Args:
        index_id(str): The identifier of the index you want to delete a group from.
        data_source_id(str, optional): The identifier of the data source you want to delete a group from. This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source. Defaults to None.
        group_id(str): The identifier of the group you want to delete.
        ordering_id(int, optional): The timestamp identifier you specify to ensure Amazon Kendra does not override the latest DELETE action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action. The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling PutPrincipalMapping. This ensures your DELETE action for that updated group with the latest members list doesn't get overwritten by earlier DELETE actions for the same group which are yet to be processed. The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.principal_mapping.delete(
                ctx, index_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.principal_mapping.delete index_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="delete_principal_mapping",
        op_kwargs={
            "IndexId": index_id,
            "DataSourceId": data_source_id,
            "GroupId": group_id,
            "OrderingId": ordering_id,
        },
    )


async def describe(
    hub, ctx, index_id: str, group_id: str, data_source_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the processing of PUT and DELETE actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.

    Args:
        index_id(str): The identifier of the index required to check the processing of PUT and DELETE actions for mapping users to their groups.
        data_source_id(str, optional): The identifier of the data source to check the processing of PUT and DELETE actions for mapping users to their groups. Defaults to None.
        group_id(str): The identifier of the group required to check the processing of PUT and DELETE actions for mapping users to their groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.principal_mapping.describe(
                ctx, index_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.principal_mapping.describe index_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_principal_mapping",
        op_kwargs={
            "IndexId": index_id,
            "DataSourceId": data_source_id,
            "GroupId": group_id,
        },
    )


async def put(
    hub,
    ctx,
    index_id: str,
    group_id: str,
    group_members: Dict,
    data_source_id: str = None,
    ordering_id: int = None,
    role_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Maps users to their groups. You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results.  You map users to their groups when you want to filter search results for different users based on their group’s access to documents. For more information on filtering search results for different users, see Filtering on user context. If more than five PUT actions for a group are currently processing, a validation exception is thrown.

    Args:
        index_id(str): The identifier of the index you want to map users to their groups.
        data_source_id(str, optional): The identifier of the data source you want to map users to their groups. This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce. Defaults to None.
        group_id(str): The identifier of the group you want to map its users to.
        group_members(Dict): The list that contains your users or sub groups that belong the same group. For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing". If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.
        ordering_id(int, optional): The timestamp identifier you specify to ensure Amazon Kendra does not override the latest PUT action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action. The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling PutPrincipalMapping. This ensures your PUT action for that updated group with the latest members list doesn't get overwritten by earlier PUT actions for the same group which are yet to be processed. The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group. For more information, see IAM roles for Amazon Kendra. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.principal_mapping.put(
                ctx, index_id=value, group_id=value, group_members=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.principal_mapping.put index_id=value, group_id=value, group_members=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="put_principal_mapping",
        op_kwargs={
            "IndexId": index_id,
            "DataSourceId": data_source_id,
            "GroupId": group_id,
            "GroupMembers": group_members,
            "OrderingId": ordering_id,
            "RoleArn": role_arn,
        },
    )
