"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def query(
    hub,
    ctx,
    index_id: str,
    query_text: str,
    attribute_filter: Dict = None,
    facets: List = None,
    requested_document_attributes: List = None,
    query_result_type_filter: str = None,
    document_relevance_override_configurations: List = None,
    page_number: int = None,
    page_size: int = None,
    sorting_configuration: Dict = None,
    user_context: Dict = None,
    visitor_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches an active index. Use this API to search your documents using query. The Query operation enables to do faceted search and to filter results based on document attributes. It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the search results.  Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response contains three types of results.   Relevant passages   Matching FAQs   Relevant documents   You can specify that the query return only one type of result using the QueryResultTypeConfig parameter. Each query returns the 100 most relevant results.

    Args:
        index_id(str): The unique identifier of the index to search. The identifier is returned in the response from the CreateIndex operation.
        query_text(str): The text to search for.
        attribute_filter(Dict, optional): Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters parameters contain a list of other filters. The AttributeFilter parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results. Defaults to None.
        facets(List, optional): An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user. Defaults to None.
        requested_document_attributes(List, optional): An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. . Defaults to None.
        query_result_type_filter(str, optional): Sets the type of query. Only results for the specified query type are returned. Defaults to None.
        document_relevance_override_configurations(List, optional): Overrides relevance tuning configurations of fields or attributes set at the index level. If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning. If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level. If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1. Defaults to None.
        page_number(int, optional): Query results are returned in pages the size of the PageSize parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one. Defaults to None.
        page_size(int, optional): Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned. Defaults to None.
        sorting_configuration(Dict, optional): Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance. If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result. Defaults to None.
        user_context(Dict, optional): The user context token. Defaults to None.
        visitor_id(str, optional): Provides an identifier for a specific user. The VisitorId should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the VisitorId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.init.query(ctx, index_id=value, query_text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.init.query index_id=value, query_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="query",
        op_kwargs={
            "IndexId": index_id,
            "QueryText": query_text,
            "AttributeFilter": attribute_filter,
            "Facets": facets,
            "RequestedDocumentAttributes": requested_document_attributes,
            "QueryResultTypeFilter": query_result_type_filter,
            "DocumentRelevanceOverrideConfigurations": document_relevance_override_configurations,
            "PageNumber": page_number,
            "PageSize": page_size,
            "SortingConfiguration": sorting_configuration,
            "UserContext": user_context,
            "VisitorId": visitor_id,
        },
    )
