"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Kendra indexes that you have created.

    Args:
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (DataSourceSummaryItems). . Defaults to None.
        max_results(int, optional): The maximum number of data sources to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.indice.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.indice.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_indices",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
