"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    role_arn: str,
    edition: str = None,
    server_side_encryption_configuration: Dict = None,
    description: str = None,
    client_token: str = None,
    tags: List = None,
    user_token_configurations: List = None,
    user_context_policy: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon Kendra index. Index creation is an asynchronous operation. To determine if index creation has completed, check the Status field returned from a call to DescribeIndex. The Status field is set to ACTIVE when the index is ready to use. Once the index is active you can index your documents using the BatchPutDocument operation or using one of the supported data sources.

    Args:
        name(str): The name for the new index.
        edition(str, optional): The Amazon Kendra edition to use for the index. Choose DEVELOPER_EDITION for indexes intended for development, testing, or proof of concept. Use ENTERPRISE_EDITION for your production databases. Once you set the edition for an index, it can't be changed. The Edition parameter is optional. If you don't supply a value, the default is ENTERPRISE_EDITION. For more information on quota limits for enterprise and developer editions, see Quotas. Defaults to None.
        role_arn(str): An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the BatchPutDocument operation to index documents from an Amazon S3 bucket.
        server_side_encryption_configuration(Dict, optional): The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Defaults to None.
        description(str, optional): A description for the index. Defaults to None.
        client_token(str, optional): A token that you provide to identify the request to create an index. Multiple calls to the CreateIndex operation with the same client token will create only one index. Defaults to None.
        tags(List, optional): A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources. Defaults to None.
        user_token_configurations(List, optional): The user token configuration. Defaults to None.
        user_context_policy(str, optional): The user context policy.  ATTRIBUTE_FILTER  All indexed content is searchable and displayable for all users. If there is an access control list, it is ignored. You can filter on user and group attributes.   USER_TOKEN  Enables SSO and token-based user access control. All documents with no access control and all documents accessible to the user will be searchable and displayable.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.index.create(ctx, name=value, role_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.index.create name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="create_index",
        op_kwargs={
            "Name": name,
            "Edition": edition,
            "RoleArn": role_arn,
            "ServerSideEncryptionConfiguration": server_side_encryption_configuration,
            "Description": description,
            "ClientToken": client_token,
            "Tags": tags,
            "UserTokenConfigurations": user_token_configurations,
            "UserContextPolicy": user_context_policy,
        },
    )


async def delete(hub, ctx, id_: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the Status field returned by a call to the DescribeIndex operation is set to DELETING.

    Args:
        id_(str): The identifier of the index to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.index.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.index.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="kendra", operation="delete_index", op_kwargs={"Id": id_}
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing Amazon Kendra index

    Args:
        id_(str): The name of the index to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.index.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.index.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="kendra", operation="describe_index", op_kwargs={"Id": id_}
    )


async def update(
    hub,
    ctx,
    id_: str,
    name: str = None,
    role_arn: str = None,
    description: str = None,
    document_metadata_configuration_updates: List = None,
    capacity_units: Dict = None,
    user_token_configurations: List = None,
    user_context_policy: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates an existing Amazon Kendra index.

    Args:
        id_(str): The identifier of the index to update.
        name(str, optional): The name of the index to update. Defaults to None.
        role_arn(str, optional): A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs. Defaults to None.
        description(str, optional): A new description for the index. Defaults to None.
        document_metadata_configuration_updates(List, optional): The document metadata to update. . Defaults to None.
        capacity_units(Dict, optional): Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day. If you are using extra storage units, you can't reduce the storage capacity below that required to meet the storage needs for your index. Defaults to None.
        user_token_configurations(List, optional): The user token configuration. Defaults to None.
        user_context_policy(str, optional): The user user token context policy. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.index.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.index.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="update_index",
        op_kwargs={
            "Id": id_,
            "Name": name,
            "RoleArn": role_arn,
            "Description": description,
            "DocumentMetadataConfigurationUpdates": document_metadata_configuration_updates,
            "CapacityUnits": capacity_units,
            "UserTokenConfigurations": user_token_configurations,
            "UserContextPolicy": user_context_policy,
        },
    )
