"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "group_older_than_ordering_id"


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    index_id: str,
    ordering_id: int,
    data_source_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.

    Args:
        index_id(str): The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.
        data_source_id(str, optional): The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier. Defaults to None.
        ordering_id(int): The timestamp identifier used for the latest PUT or DELETE action for mapping users to their groups.
        next_token(str, optional):  The next items in the list of groups that go beyond the maximum. . Defaults to None.
        max_results(int, optional):  The maximum results shown for a list of groups that are mapped to users before a given ordering or timestamp identifier. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.group_older_than_ordering_id_.list(
                ctx, index_id=value, ordering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.group_older_than_ordering_id.list index_id=value, ordering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_groups_older_than_ordering_id",
        op_kwargs={
            "IndexId": index_id,
            "DataSourceId": data_source_id,
            "OrderingId": ordering_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
