"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def submit(
    hub,
    ctx,
    index_id: str,
    query_id: str,
    click_feedback_items: List = None,
    relevance_feedback_items: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Enables you to provide feedback to Amazon Kendra to improve the performance of your index.

    Args:
        index_id(str): The identifier of the index that was queried.
        query_id(str): The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the Query operation.
        click_feedback_items(List, optional): Tells Amazon Kendra that a particular search result link was chosen by the user. . Defaults to None.
        relevance_feedback_items(List, optional): Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.feedback.submit(ctx, index_id=value, query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.feedback.submit index_id=value, query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="submit_feedback",
        op_kwargs={
            "IndexId": index_id,
            "QueryId": query_id,
            "ClickFeedbackItems": click_feedback_items,
            "RelevanceFeedbackItems": relevance_feedback_items,
        },
    )
