"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, index_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of FAQ lists associated with an index.

    Args:
        index_id(str): The index that contains the FAQ lists.
        next_token(str, optional): If the result of the previous request to ListFaqs was truncated, include the NextToken to fetch the next set of FAQs. Defaults to None.
        max_results(int, optional): The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.faqs.list(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.faqs.list index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_faqs",
        op_kwargs={
            "IndexId": index_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
