"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    index_id: str,
    name: str,
    s3_path: Dict,
    role_arn: str,
    description: str = None,
    tags: List = None,
    file_format: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an new set of frequently asked question (FAQ) questions and answers.

    Args:
        index_id(str): The identifier of the index that contains the FAQ.
        name(str): The name that should be associated with the FAQ.
        description(str, optional): A description of the FAQ. Defaults to None.
        s3_path(Dict): The S3 location of the FAQ input data.
        role_arn(str): The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see IAM Roles for Amazon Kendra.
        tags(List, optional): A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources. Defaults to None.
        file_format(str, optional): The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes. The format must match the format of the file stored in the S3 bucket identified in the S3Path parameter. For more information, see Adding questions and answers. Defaults to None.
        client_token(str, optional): A token that you provide to identify the request to create a FAQ. Multiple calls to the CreateFaqRequest operation with the same client token will create only one FAQ. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.faq.create(
                ctx, index_id=value, name=value, s3_path=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.faq.create index_id=value, name=value, s3_path=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="create_faq",
        op_kwargs={
            "IndexId": index_id,
            "Name": name,
            "Description": description,
            "S3Path": s3_path,
            "RoleArn": role_arn,
            "Tags": tags,
            "FileFormat": file_format,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, id_: str, index_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes an FAQ from an index.

    Args:
        id_(str): The identifier of the FAQ to remove.
        index_id(str): The index to remove the FAQ from.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.faq.delete(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.faq.delete id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="delete_faq",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def describe(hub, ctx, id_: str, index_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an FAQ list.

    Args:
        id_(str): The unique identifier of the FAQ.
        index_id(str): The identifier of the index that contains the FAQ.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.faq.describe(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.faq.describe id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_faq",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )
