"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    index_id: str,
    document_id_list: List,
    data_source_sync_job_metric_target: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more documents from an index. The documents must have been added with the BatchPutDocument operation. The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.

    Args:
        index_id(str): The identifier of the index that contains the documents to delete.
        document_id_list(List): One or more identifiers for documents to delete from the index.
        data_source_sync_job_metric_target(Dict, optional): Maps a particular data source sync job to a particular data source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.delete_document.batch(
                ctx, index_id=value, document_id_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.delete_document.batch index_id=value, document_id_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="batch_delete_document",
        op_kwargs={
            "IndexId": index_id,
            "DocumentIdList": document_id_list,
            "DataSourceSyncJobMetricTarget": data_source_sync_job_metric_target,
        },
    )
