"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    id_: str,
    index_id: str,
    next_token: str = None,
    max_results: int = None,
    start_time_filter: Dict = None,
    status_filter: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets statistics about synchronizing Amazon Kendra with a data source.

    Args:
        id_(str): The identifier of the data source.
        index_id(str): The identifier of the index that contains the data source.
        next_token(str, optional): If the result of the previous request to GetDataSourceSyncJobHistory was truncated, include the NextToken to fetch the next set of jobs. Defaults to None.
        max_results(int, optional): The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results. Defaults to None.
        start_time_filter(Dict, optional): When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. . Defaults to None.
        status_filter(str, optional): When specified, only returns synchronization jobs with the Status field equal to the specified status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.sync_job.list_all(
                ctx, id_=value, index_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.sync_job.list_all id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_data_source_sync_jobs",
        op_kwargs={
            "Id": id_,
            "IndexId": index_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "StartTimeFilter": start_time_filter,
            "StatusFilter": status_filter,
        },
    )


async def start(hub, ctx, id_: str, index_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a synchronization job for a data source. If a synchronization job is already in progress, Amazon Kendra returns a ResourceInUseException exception.

    Args:
        id_(str): The identifier of the data source to synchronize.
        index_id(str): The identifier of the index that contains the data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.sync_job.start(
                ctx, id_=value, index_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.sync_job.start id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="start_data_source_sync_job",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def stop(hub, ctx, id_: str, index_id: str) -> None:
    r"""
    **Autogenerated function**

    Stops a running synchronization job. You can't stop a scheduled synchronization job.

    Args:
        id_(str): The identifier of the data source for which to stop the synchronization jobs.
        index_id(str): The identifier of the index that contains the data source.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.sync_job.stop(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.sync_job.stop id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="stop_data_source_sync_job",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )
